/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;

public class CycleItemsPacket {
    private final TYPE type;

    public CycleItemsPacket(TYPE type) {
        this.type = type;
    }

    public CycleItemsPacket(PacketBuffer buffer) {
        this.type = TYPE.values()[buffer.readByte()];
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte(this.type.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity sender = ctx.getSender();
            if (sender.field_71070_bA instanceof PlaneWorkbenchContainer) {
                PlaneWorkbenchContainer workbenchContainer = (PlaneWorkbenchContainer)sender.field_71070_bA;
                workbenchContainer.cycleItems(this.type);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum TYPE {
        CRAFTING_LEFT,
        CRAFTING_RIGHT;

    }
}

